<?php
require 'koneksi.php';
require_once("dompdf/autoload.inc.php");

use Dompdf\Dompdf;
use Dompdf\Options;

// **Konfigurasi Dompdf**
$options = new Options();
$options->set('isRemoteEnabled', true);
$options->set('isHtml5ParserEnabled', true);
$options->set('defaultFont', 'Arial');
$options->set('isPhpEnabled', true);
$options->set('isFontSubsettingEnabled', true);

$dompdf = new Dompdf($options);

// **Ambil Data dari Database**
$bobot = query("SELECT * FROM bobot1")[0];  // Ambil bobot
$nilai_alternatif = query("SELECT * FROM mahasiswa ORDER BY id ASC");  // Urutkan berdasarkan ID asli
$hasil_vektor_s = query("SELECT * FROM vektors1 ORDER BY id ASC");  // Ambil berdasarkan ID asli
$hasil_vektor_v = query("SELECT * FROM hasil1 ORDER BY id_hasil ASC");  // Ambil berdasarkan ID asli

// **Cek apakah semua data sudah ada**
if (!$bobot || !$nilai_alternatif || !$hasil_vektor_s || !$hasil_vektor_v) {
    die("⚠️ Data tidak tersedia! Pastikan tabel `bobot1`, `input_nilai1`, `vektors1`, dan `hasil1` sudah diisi.");
}

// **Hitung total bobot**
$jumlah_bobot = array_sum($bobot);
if ($jumlah_bobot == 0) {
    die("⚠️ Bobot tidak boleh nol! Periksa kembali bobot yang diinput.");
}

// **Normalisasi Bobot**
$w = [];
foreach ($bobot as $key => $value) {
    if ($key != 'id_bobot1') {
        $w[$key] = $value / $jumlah_bobot;
    }
}

// **Total Vektor S & V**
$total_s = array_sum(array_column($hasil_vektor_s, 'nilai'));
$total_v = array_sum(array_column($hasil_vektor_v, 'nilai'));

// **Tanggal otomatis**
$tanggal = date("d-m-Y");

// **Struktur HTML untuk PDF**
$html = '<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        .table1 {
            width: 100%;
            border-collapse: collapse;
            text-align: center;
        }
        .table1, th, td {
            border: 1px solid #000;
            padding: 5px;
            font-size: 10px;
        }
        h2, p {
            text-align: center;
        }
        h3 {
            text-decoration: underline;
            text-align: center;
        }
        h1 {
            text-align: center;
            font-size: 22px;
        }
    </style>
</head>
<body>
    <br>
    <h1>Laporan Hasil Evaluasi Efektivitas Penggunaan YouTube sebagai Media Pembelajaran Mahasiswa Teknik Informatika dengan Metode Weighted Product</h1>
    <h2>Nusa Putra University</h2>
    <p>Sukabumi - Bogor - West Java - Indonesia</p>
    <p>Date: ' . htmlspecialchars($tanggal) . '</p>
<hr style="border: 2px solid black;" />

    <br><br>';

    
// **Tabel Bobot Kriteria**
$html .= '<h3>Data Bobot Kriteria</h3>
<table class="table1">
<tr>
    <th>Kriteria</th>
    <th>Bobot</th>
    <th>Bobot Normalisasi</th>
</tr>';

foreach ($w as $key => $value) {
    $html .= '<tr>
        <td>' . strtoupper($key) . '</td>
        <td>' . intval($bobot[$key]) . '</td>  <!-- Tanpa desimal -->
        <td>' . number_format($value, 6) . '</td>  <!-- 6 angka desimal -->
    </tr>';
}
$html .= '</table><br><br>';
$html .= '<hr style="border: 1px solid #ccc;">';


// **Tabel Nilai Alternatif**
$html .= '<h3>Data Nilai Alternatif</h3>
<table class="table1">
<tr>
    <th>No.</th>
    <th>Name</th>
    <th>C1</th>
    <th>C2</th>
    <th>C3</th>
    <th>C4</th>
    <th>C5</th>
    <th>C6</th>
    <th>C7</th>
    <th>Nilai Rata-rata</th> 
</tr>';

$no = 1;
$total_rata_rata = 0;  // For calculating total average
foreach ($nilai_alternatif as $alt) {
    // Calculate average for each alternative
    $nilai = [
        $alt["c1"], $alt["c2"], $alt["c3"], $alt["c4"], $alt["c5"], $alt["c6"], $alt["c7"]
    ];
    $rata_rata = array_sum($nilai) / count($nilai);  // Calculate the average
    $total_rata_rata += $rata_rata;  // Add to total average

    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . htmlspecialchars($alt["alternatif"]) . '</td>
        <td>' . intval($alt["c1"]) . '</td>  
        <td>' . intval($alt["c2"]) . '</td>
        <td>' . intval($alt["c3"]) . '</td>
        <td>' . intval($alt["c4"]) . '</td>
        <td>' . intval($alt["c5"]) . '</td>
        <td>' . intval($alt["c6"]) . '</td>
        <td>' . intval($alt["c7"]) . '</td>
        <td>' . number_format($rata_rata, 6) . '</td> 
    </tr>';
}
$html .= '</table><br><br>';
// **Total Average**
$total_average = $total_rata_rata / count($nilai_alternatif);  // Divide by number of alternatives
$html .= "<p style='text-align:center; font-weight:bold;'>Total Rata-rata dari Seluruh Alternatif: " . number_format($total_average, 6) . "</p><br><br>";
$html .= '</table><br><br>';
$html .= '<hr style="border: 1px solid #ccc;">';

// **Tabel Hasil Vektor S**
$html .= '<h3>Hasil Vektor S</h3>
<table class="table1">
<tr>
    <th>No.</th>
    <th>Alternatif</th>
    <th>Nilai Vektor S</th>
</tr>';

$no = 1;
foreach ($hasil_vektor_s as $data) {
    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . htmlspecialchars($data["alternatif"]) . '</td>
        <td>' . number_format($data["nilai"], 6) . '</td>
    </tr>';
}
$html .= '</table><br><br>';
$html .= "<p style='text-align:center; font-weight:bold;'>Total Nilai Vektor S : " . number_format($total_s, 6) . "</p><br><br>";

$html .= '</table><br><br>';
$html .= '<hr style="border: 1px solid #ccc;">';

// **Tabel Hasil Vektor V**
$html .= '<h3>Hasil Vektor V</h3>
<table class="table1">
<tr>
    <th>No.</th>
    <th>Alternatif</th>
    <th>Nilai Vektor V</th>
</tr>';

$no = 1;
foreach ($hasil_vektor_v as $data) {
    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . htmlspecialchars($data["alternatif"]) . '</td>
        <td>' . number_format($data["nilai"], 6) . '</td>
    </tr>';
}
$html .= '</table><br><br>';
$html .= "<p style='text-align:center; font-weight:bold;'>Total Nilai Vektor V : " . number_format($total_v, 6) . "</p><br><br>";
$html .= '</table><br><br>';
$html .= '<hr style="border: 1px solid #ccc;">';

// **Tabel Hasil Perankingan**
$html .= '<h3>Hasil Perankingan</h3>
<table class="table1">
<tr>
    <th>Peringkat</th>
    <th>Nama</th>
    <th>Nilai</th>
</tr>';

$no = 1;
$hasil_vektor_v_ranked = $hasil_vektor_v;
usort($hasil_vektor_v_ranked, fn($a, $b) => $b['nilai'] <=> $a['nilai']);  // Urutkan berdasarkan nilai tertinggi

foreach ($hasil_vektor_v_ranked as $data) {
    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . htmlspecialchars($data["alternatif"]) . '</td>
        <td>' . number_format($data["nilai"], 6) . '</td>
    </tr>';
}
$html .= '</table><br><br>';

// **Tutup HTML**
$html .= "</body></html>";

// **Proses PDF dengan Dompdf**
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'landscape');
$dompdf->render();
$dompdf->stream('Laporan_Evaluasi_YouTube.pdf', array("Attachment" => 0));
?>
